"use strict";

$(function() {
	
	let age = 60 * 2;
	
	let scanner = function() {
		
		if( /st\-scan=1/.test(document.cookie) ) return;
		
		$.ajax({
			url: Uss['ud-ajax'],
			method: 'POST',
			data: { 
				nonce: Uss.Nonce,
				route: 'uss-helpdesk'
			},
			success: function(response) {
				try {
					
					let result = JSON.parse( response );
					if( !result.status ) return;
					
					toastr.warning( result.message, null, {
						positionClass: 'toast-bottom-right',
						closeButton: true,
						timeOut: 0,
						extendedTimeOut: 0,
						onclick: function() {
							document.cookie = "st-scan=1;max-age=" + age;
						},
						preventDuplicates: true
					});
					
				} catch(e) {};
			}
		});
	
	};
	
	scanner();
	
	setInterval(function() {
		scanner();
	}, (1000 * age));

});