<?php 

defined( 'UDASH_DIR' ) OR DIE;


// DASHBOARD PANEL CHAT!

Uss::route( $FOCUS . "/chat(/\w*)?", function() use($FOCUS, $menu_title) {
	
	# Make support ticket menu active;
	
	$ticketMenu = Uss::$global['menu']->get( $menu_title )->get('list');
	$ticketMenu->setAttr( 'active', true );
	$ticketMenu->parentMenu->setAttr('active', true );
	
	# Grab the ticket ID
	
	$uniqid = Uss::$global['mysqli']->real_escape_string( Uss::query(3) );
	
	# Get the ticket data!

	$prefix = DB_TABLE_PREFIX;
	
	$userid = Uss::$global['user']['id'];
	
	$TICKET_SQL = sQuery::select( "{$prefix}_tickets", "uniqid = '{$uniqid}' AND userid = '{$userid}'" );
	
	$ticket = Uss::$global['mysqli']->query( $TICKET_SQL )->fetch_assoc();
	
	# Mark Seen!
	
	if( $ticket ) {
			
		$SQL = sQuery::update( "{$prefix}_ticket_replies", array( 'seen' => 1 ), "
			ticket_id = '{$ticket['id']}'
			AND viewpoint = 'admin'
		");
		
		Uss::$global['mysqli']->query( $SQL );
		
	};
	
	
	# Use the ticket data to handle POST
	
	require realpath( __DIR__ . '/../' ) . '/utils/chat-POST.php';
	
	$ticket = $chat->refresh();
	
	udash::view(function() use($ticket, $FOCUS) {
		
		
		//! If no ticket was found! Leave an empty state message
		
		if( !$ticket ) {
			return udash::empty_state(function() use($FOCUS) {
				$href = core::url( ROOT_DIR . '/' . $FOCUS );
				echo "
					<p>Sorry! We couldn't find any matching support ticket</p>
					<a href='{$href}' class='btn btn-primary'>View Tickets</a>
				";
			});
		};
		
		
		//! Remove javascript tags if exists;
		
		$regex = "/\<\/?script(?:[^>]*?)\>/";
		$ticket['description'] = preg_replace( $regex, null, $ticket['description'] );
		
?>
		<div class='container-fluid'>
			<div class='row'>
				
				<div class='col-lg-5 col-md-10 mx-auto mb-4'>
				
					<?php 
						events::addListener('dashboard.support-ticket-chat:col-left', function() use($ticket) {
					?>
					
					<div class='card mb-3 ticket-sticker'>
						<div class='card-body'>
						
							<div class='text-end text-sm text-danger fw-semibold'>
								<?php echo $ticket['uniqid']; ?>
							</div>
							
							<hr class='my-2'>
							
							<p class='fw-semibold'>
								<?php echo $ticket['subject']; ?>
							</p> <!--- [description] --->
							
							<div class='border bg-light ticket-issue rounded-3 p-3 mb-3'>
								<?php echo $ticket['description']; ?>
							</div>
							
							<hr>
							
							<?php if( $ticket['status'] === 'open' ): ?>
							
								<form method='POST' data-uss-confirm='You are about to cancel this unresolved ticket!'>
									<input type='hidden' name='type' value='state'>
									<input type='hidden' name='nonce' value='<?php echo Uss::nonce( 'chat' ); ?>'>
									<button class='btn btn-danger btn-sm w-100' name='status' value='cancelled'>
										<i class='bi bi-exclamation-triangle'></i> Cancel Ticket
									</button>
								</form>
								
							<?php else: ?>
							
								<div class='p-2 opacity-50 rounded-2 text-white text-center mb-3 bg-<?php echo udash::get_color($ticket['status']); ?> user-select-none text-capitalize'>
									<?php echo $ticket['status']; ?>
								</div>
								
								<p class='fs-20px fw-light text-center'>Thank you for contact us</p>
							
							<?php endif; ?>
							
						</div>
					</div>
					
					<?php }, 'chat-detail'); ?>
					
					<?php 
						events::exec('dashboard.support-ticket-chat:col-left', array(
							'ticket' => $ticket
						)); 
					?>
					
				</div>
				
				<div class='col-lg-7 col-md-10 mx-auto'>
					
					<?php 
						events::addListener('dashboard.support-ticket-chat:col-right', function() use($ticket) { 
							// Get the chat boxes from "utils" directory
							require realpath( __DIR__ . '/../' ) . "/utils/chat-board.php";
						}, 'chat-block'); 
					?>
					
					<?php 
						events::addListener('dashboard.support-ticket-chat:col-right', function() use($ticket) { 
							// Get the textarea field from "utils" directory
							require realpath( __DIR__ . '/../' ) . '/utils/textarea.php';
						}, 'chat-input'); 
					?>
					
					<?php 
						events::exec('dashboard.support-ticket-chat:col-right', array(
							'ticket' => $ticket
						)); 
					?>
					
				</div>
				
			</div>
		</div>
	
<?php	});
	
});