<?php
    Events::addListener('@head:before', function() { 
?>

    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>%{@site:title}</title>
    <meta name="description" content="%{@site:description}">

    <!-- CSS here -->
    <link rel="stylesheet" href="%{:assets-dir}/css/animate.css">
    <link rel="stylesheet" href="%{:assets-dir}/css/swiper-bundle.css">
    <link rel="stylesheet" href="%{:assets-dir}/css/slick.css">
    <link rel="stylesheet" href="%{:assets-dir}/css/magnific-popup.css">
    <link rel="stylesheet" href="%{:assets-dir}/css/font-awesome-pro.css"> 
    <link rel="stylesheet" href="%{:assets-dir}/css/flaticon.css">
    <link rel="stylesheet" href="%{:assets-dir}/css/spacing.css">
    <link rel="stylesheet" href="%{:assets-dir}/css/main.css">
    
    <link rel="shortcut icon" type="image/x-icon" href="%{@site:icon}">

    <style>
        .preloader {
            background-position: center;
            background-repeat: no-repeat;
            background-image: url(%{@site:icon});
            background-size: 120px 120px;
        }
    </style>

<?php }, 'bank-header'); ?>

<?php   
    Events::addListener('@body:before', function() {
?>
      <!-- pre loader area start -->
      <div id="loading">
         <div id="loading-center">
            <div class="preloader"></div>
         </div>  
      </div>
      <!-- pre loader area end -->


      <!-- back to top start -->
      <div class="back-to-top-wrapper">
         <button id="back_to_top" type="button" class="back-to-top-btn">
            <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path d="M11 6L6 1L1 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>               
         </button>
      </div>
      <!-- back to top end -->


      <!-- search area start -->
      <div class="search-area">
         <div class="search-inner p-relative">
            <div class="container">
               <div class="row justify-content-center">
                  <div class="col-lg-8">
                     <div class="search-wrapper">
                        <div class="search-close">
                           <button class="search-close-btn">
                              <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                 <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                              </svg>
                           </button>
                        </div>
                        <div class="search-content pt-35">
                           <h3 class="heading text-center mb-30">Hi! How can we help You?</h3>
                           <div class="d-flex justify-content-center px-5">
                              <div class="search w-100 p-relative">
                                 <input type="text" class="search-input" placeholder="Search...">
                                 <button  class="search-icon">
                                 <i class="fa fa-search"></i>
                                 </button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div class="search-overlay"></div>
      <!-- search area end -->


      <!-- offcanvas area start -->
      <div class="offcanvas__area">
         <div class="offcanvas__wrapper">
            <div class="offcanvas__close">
               <button class="offcanvas__close-btn offcanvas-close-btn">
                  <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                     <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                  </svg>
               </button>
            </div>
            <div class="offcanvas__content">
               <div class="offcanvas__top mb-50 d-flex justify-content-between align-items-center">
                  <div class="offcanvas__logo logo">
                     <a href="<?php echo Core::url( ROOT_DIR ); ?>">
                        <img src="%{@site:icon}" alt="logo" height='50px'>
                     </a>
                  </div>
               </div>

                  <div class="tp-main-menu-mobile fix d-xl-none mb-40"></div>
               
            </div>
         </div>
      </div>
      <div class="body-overlay"></div>
      <!-- offcanvas area end -->


      <!-- header area start -->
      <header id="header-sticky" class="tp-header-area p-relative">
         <div class="tp-header-box p-relative">
            <div class="tp-header-logo p-relative">
               <span class="tp-header-logo-bg"></span>
               <a href="<?php echo Core::url( ROOT_DIR ); ?>">
                  <img src="%{@site:icon}" alt="" height='50px'>
               </a>
            </div>
            <div class="tp-header-wrapper-inner header__sticky p-relative">
               <div class="tp-header-main-menu d-flex align-items-center justify-content-between">
                  <div class="tp-main-menu d-none d-xl-block">
                     <nav class="tp-main-menu-content">
                        <ul>
                            <?php 
                                foreach( Home::$menu->child as $menu ) {
                                    echo Home::buildMenu( $menu ); 
                                };
                            ?>
                        </ul>
                     </nav>
                  </div>
                  <div class="tp-header-main-right d-flex align-items-center justify-content-xl-end">
                     <div class="tp-header-contact d-xl-flex align-items-center d-none">
                        <div class="tp-header-contact-search search-open-btn d-none d-xxl-block">
                           <span><i class="fa-solid fa-magnifying-glass"></i></span>
                        </div>
                        
                     </div>
                     <div class="tp-header-sticky-hamburger d-xl-none offcanvas-open-btn">
                        <button class="hamburger-btn">
                           <span></span>
                           <span></span>
                           <span></span>
                        </button>
                     </div>
                  </div>
               </div>
            </div>
            <div class="tp-header-btn">

               <!------- GET A QUOTE --------->
               <a class="tp-btn d-none d-xl-block" href="<?php echo Core::url( ROOT_DIR . "/" . UDASH_ROUTE ); ?>">
                  E-BANKING <i class="fa fa-lock"></i>
               </a>
               <!-------- / GET A QUOTE ------>

               <div class="tp-header-main-right-hamburger-btn d-xl-none offcanvas-open-btn">
                  <button class="hamburger-btn">
                     <span></span>
                     <span></span>
                     <span></span>
                  </button>
               </div>

            </div>
         </div>
      </header>
      <!-- header area end -->

      <!-- sticky header start -->
      
      <!-- sticky header end -->
      <main>

        <?php if( !empty(Home::$title) ): ?>

         <!-- about breadcrumb area start -->
         <section class="breadcrumb__area pt-165 pb-150 p-relative z-index-1 fix text-capitalize" data-bg-color="#16243E">
            <div class="breadcrumb__bg" data-background="%{:assets-dir}/img/breadcrumb/bg.png"></div>
            <div class="container">
               <div class="row align-items-center">
                  <div class="col-sm-6">
                     <div class="breadcrumb__content">
                        <h3 class="breadcrumb__title"><?php echo Home::$title; ?></h3>
                     </div>
                  </div>
                  <div class="col-sm-6">
                     <div class="breadcrumb__content">
                     <div class="breadcrumb__list text-center text-sm-end">
                        <span><a href="<?php echo Core::url( ROOT_DIR ); ?>">Home</a></span>
                        <span class="dvdr"><i class="fa-regular fa-angle-right"></i></span>
                        <span><?php echo Home::$title; ?></span>
                     </div>
                     </div>
                  </div>
               </div>
            </div>
         </section>
         <!-- about breadcrumb area end -->

        <?php endif; ?>

<?php }, -1999 );