<div class="container-fluid">

    <div class='row'>
        <div class='col-lg-5 mb-4'>

            <div class='card'>
                <div class='card-body'>

                    <h3>Select a Payment Method</h3>

                    <hr>

                    <form method='GET'>

                        <select class='form-select form-select-lg mb-3' name='method'>
                            <?php 
                                foreach( $methods as $unit_method ): 
                                    $selected = ( $unit_method['id'] == ($_GET['method'] ?? null) ) ? 'selected' : null;
                            ?>
                                <option value='<?php echo $unit_method['id']; ?>' <?php echo $selected; ?>>
                                    <?php echo $unit_method['name']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>

                        <button class='btn btn-primary w-100'>
                            Select
                        </button>
                        
                    </form>

                </div>
            </div>

        </div>

        <div class='col-lg-7'>

            <div class='card'>
                <div class='card-body'>
                    
                    <?php
                        
                        if( !empty($method) ):

                    ?>

                        <div class='p-sm-4'>

                            <div class='text-center'>

                                <div class='mb-2'>
                                    <img src='' class='img-fluid' width='100px'>
                                </div>

                                <h3><?php echo $method['name']; ?> Payment</h3>

                                <?php Monetary::flushQRCode(); ?>

                            </div>

                            <div class='border-top my-4'></div>
                                
                            <div class='card'>
                                <div class='card-body'>

                                    <div class='p-sm-3'>

                                        <?php 

                                            if( $method['medium'] != 'bank' ) {
                                                require __DIR__ . "/method-wallet.php"; 
                                            } else {
                                                require __DIR__ . "/method-bank.php";
                                            };

                                        ?>

                                    </div>

                                </div>
                            </div>

                        </div>

                    <?php else: ?>

                        <div class='p-3 p-sm-4 text-center'>

                            <figure class='mb-4 border p-4 rounded-2'>
                                <img src='<?php echo Core::url( MONETARY_DIR . "/images/payment.jpeg" ); ?>' class='img-fluid'>
                            </figure>

                            <h3 class='display-6 mb-3'>
                                <span class='uss-ellipsis-loading'>Waiting</span>
                            </h3>

                            <h4 class='fw-normal'>Please Select Deposit Method</h4>

                        </div>

                    <?php endif; ?>

                </div>
            </div>

        </div>
    </div>

</div>