<?php

$kyc = new class {

    public function __construct() {

        if( $_SERVER['REQUEST_METHOD'] != 'POST' ) return;

        $this->handleUpload();

    }

    public function handleUpload() {

        $file = $_FILES['kyc'];

        if( !empty($file['error']) ) {
            return Bank::log( 'error', "Uploaded file is missen or error prone!" );
        };

        try {

            $userid = Uss::$global['user']['id'];

            $link = Udash::uploadFile(
                "image/jpeg|jpg|png|gif|webp",
                $file,
                ACC_DIR . "/images/kyc",
            );

            $account = Uss::$global['usermeta']->get('bank:account', $userid) ?? [];

            $account['kyc'] = $link;

            $inject = Uss::$global['usermeta']->set('bank:account', $account, $userid);

            if( $inject ) {
                
                Bank::log( 'success', "Thank you for uploading your KYC Document. <br/> Our support team will review it" );

            } else {

                Bank::log( 'error', "Sorry! The KYC Document was not uploaded" );

            };

        } catch( Exception $e ) {

            Bank::log( 'error', "An error occured during the upload. Please try again" );

        };

    }

};