<?php

$insight = new class {

    public $currencies;
    public $user;
    public $bankinfo;

    protected $request;
    protected $post;

    public function __construct() {
        
        $this->setUp();

        if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
            $this->handleRequests();
        }

    }

    protected function setUp() {
        $this->currencies = Uss::$global['options']->get('bank:currencies');
        $this->user = Uss::$global['user'];
        $this->bankinfo = Uss::$global['usermeta']->get('bank:info', $this->user['id']);
    }

    protected function handleRequests() {

        $this->request = $_POST['request'] ?? null;

        if( $this->request ) {
            unset( $_POST['request'] );
        };

        $this->post = array_map(function($value) {
            return Uss::$global['mysqli']->real_escape_string( trim($value) );
        }, $_POST);

        if( $this->request == 'currency-update' ) {
            $this->updateCurrency();
        };

    }

    protected function updateCurrency() {
        
        # Update Info;
        $this->bankinfo['system']['currency'] = $this->post['currency'];

        $updated = Uss::$global['usermeta']->set('bank:info', $this->bankinfo, $this->user['id']);

        if( $updated ) {
            Bank::log('success', "Your default currency has been updated");
        } else {
            Bank::log('error', "Failed to update default currency");
        }

    }

};