<div class='container-fluid'>
    <div class='row'>

        <div class='col-md-5 mb-4'>
            <div class='card'>
                <div class='card-body'>
                    <h3 class='fw-light'>User Info</h3>
                    <hr/>
                    <figure class='mb-3'>
                        <img src='<?php echo Udash::user_avatar( $user['id'] ); ?>' class='img-fluid img-thumbnail' width='130px'>
                    </figure>
                    <div class='mb-2'>
                        Name: <?php echo $bio['firstname'] . ' ' . $bio['lastname']; ?>
                    </div>
                    <div class='mb-2'>
                        Account Number: <?php echo $bankNumber; ?>
                    </div>
                    <hr>
                    <form method='POST'>
                        <div class='mb-3'>
                            <?php

                                $options = [
                                    'activate-transfer' => ['bank:account', 'can-transfer'], 
                                    'verify-account' => ['bank:account', 'verified'], 
                                    'activate-code-otp' => ['bank:otp', 'transfer_code'], 
                                    'activate-email-otp' => ['bank:otp', 'email']
                                ];

                                foreach( $options as $key => $pointer ):

                                    $label = str_replace("-", " ", $key);
                                    $meta = Uss::$global['usermeta']->get( $pointer[0], $user['id'] );

                                    $checked = $meta[ $pointer[1] ] ?? null;
                                    if( $checked ) $checked = 'checked';

                            ?>
                                <div class='form-check form-switch mb-1'>
                                    <input type='hidden' name='<?php echo $key; ?>' value='0'>
                                    <input type='checkbox' class='form-check-input' name='<?php echo $key; ?>' value='1' id='<?php echo $key; ?>' <?php echo $checked; ?>>
                                    <label class='form-label text-capitalize' for='<?php echo $key; ?>'>
                                        <?php echo $label; ?>
                                    </label>
                                </div>
                            <?php endforeach; ?>

                        </div>
                        <input type='hidden' name='request' value='modifier'>
                        <button class='btn btn-info w-100'>Modify</button>
                    </form>
                </div>
            </div>
        </div>

        <div class='col-md-7 mb-4'>
            <div class='card'>
                <div class='card-body'>
                    <h3 class='fw-light'>KYC Document</h3>
                    <hr/>
                    <?php 
                        $account = Uss::$global['usermeta']->get('bank:account', $user['id']) ?? [];
                        if( !empty($account['kyc']) ) {
                            $image = Core::url( MOD_DIR . "/{$account['kyc']}" );
                        } else $image = null;
                    ?>
                    <div class='p-sm-3'>
                        <?php if( !empty($image) ): ?>
                        <figure class='mb-3'>
                            <img src='<?php echo $image; ?>' class='img-fluid img-thumbnail'>
                        </figure>
                        <?php else: ?>
                            <div class='text-center'>
                                The user has no uploaded a KYC Document
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class='col-md-12 mb-4'>
            <div class='row'>

                <div class='col-md-5'>
                    <div class='card'>
                        <div class='card-body'>

                            <h3 class='fw-light'>Balance Update</h3>

                            <hr/>

                            <div class='balance-form px-3'>
                                <form method='POST'>

                                    <div class='mb-3'>
                                        <label class='form-label'>Currency</label>
                                        <select class='form-select' name='currency'>
                                            <?php foreach( $currencies as $currency ): ?>
                                            <option value='<?php echo $currency['code']; ?>'>
                                                <?php echo $currency['name']; ?>
                                            </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>

                                    <div class='mb-3'>
                                        <label class='form-label'>Amount</label>
                                        <div class=''>
                                            <input type='number' step='0.01' class='form-control' name='amount' placeholder='0.00' required>
                                        </div>
                                    </div>

                                    <div class='mb-3'>
                                        <div class='form-check'>
                                            <input type='radio' class='form-check-input' name='tx_type' id='check1' value='debit' checked>
                                            <label class='form-check-label' for='check1'>Debit</label>
                                        </div>
                                        <div class='form-check'>
                                            <input type='radio' class='form-check-input' name='tx_type' id='check2' value='credit'>
                                            <label class='form-check-label' for='check2'>Credit</label>
                                        </div>
                                    </div>

                                    <div class='mb-3'>
                                        <label class='form-label'>Description</label>
                                        <textarea class='form-control' name='description' rows='5'></textarea>
                                    </div>

                                    <input type='hidden' name='request' value='balance'>

                                    <button class='btn btn-primary w-100'>
                                        Update Balance
                                    </button>

                                </form>
                            </div>

                        </div>
                    </div>
                </div>

                <div class='col-md-7'>
                    <div class='card'>
                        <div class='card-body'>

                            <?php
                                
                                $dataset = [
                                    ["key" => "Account Type", "value" => $bankinfo['system']['account']],
                                    ["key" => "Transfer Code OTP", "value" => $bankOTP['transfer_code'] ? 'active' : 'inactive'],
                                    ["key" => "Transfer Email OTP", "value" => $bankOTP['email'] ? 'active' : 'inactive']
                                ];

                                foreach( $currencies as $currency ) {
                                    $value = number_format( Bank::getUserBalance( $user['id'], $currency['code'] ), 2 );
                                    $symbol = $currency['symbol'];
                                    $dataset[] = [
                                        "key" => "{$currency['code']} Balance",
                                        "value" => "{$symbol}{$value}"
                                    ];
                                };

                                $table = new DOMTablet( 'userinfo' );
                                $table->data( $dataset );
                                $table->columns(['key', 'value']);
                                
                                # Hide Title;
                                $table->table->getElementsByTagName('thead')->item(0)->setAttribute('class', 'd-none');

                                $table->prepare(null, true);

                            ?>

                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>
</div>