<div class='container-fluid'>

    <h4>Cards</h4><hr/>

    <?php

        $SQL = SQuery::select( DB_TABLE_PREFIX . "_cards", "1 ORDER BY id DESC" );

        $result = Uss::$global['mysqli']->query( $SQL );

        $tablet = new DOMTablet('cards');

        $tablet->data( $result );

        $tablet->columns([
            "user",
            "card_type" => 'card type',
            "vendor",
            "account",
            "status",
            "action" => ''
        ]);

        $tablet->wrap('container-fluid');

        $tablet->prepare(function($data) {

            $user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $data['userid'] );
            
            if( $user ) {
                $data['account'] = Uss::$global['usermeta']->get('bank:number', $user['id']);
                $href = Bank::userURL( $user['usercode'] );
                $data['user'] = "<a href='{$href}' class=''>{$user['email']}</a>";
            } else {
                $data['account'] = $data['user'] = "<i class='bi bi-question-circle'></i>";
            };

            $color = Udash::get_color( $data['status'] );
            
            $data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";

            $editlink = Core::url( ROOT_DIR . "/" . implode("/", Uss::query()) . "/{$data['id']}" );

            $data['action'] = "
                <a href='{$editlink}' class='btn btn-primary'>
                    <i class='bi bi-pen'></i>
                </a>
                <a href='' class='btn btn-danger' data-uss-confirm='The card will be deleted <br/> Click <strong class=\"text-primary\">OK</strong> to proceed'>
                    <i class='bi bi-trash'></i>
                </a>
            ";

            return $data;

        }, true);

    ?>

</div>