<div class='container-fluid'>

    <h4>Edit Card</h4><hr/>

    <div class='row'>
        <div class='col-lg-7 mx-auto'>

            <div class='card'>
                <div class='card-body'>
                    <div class='p-3 p-sm-5'>

                        <form method='POST'>

                            <div class='text-end border rounded-2 p-3 mb-3'>
                                <p> Created: <?php echo $card['date']; ?> </p>
                                <p class='mb-0'> 
                                    Owner: <a href='<?php echo $href; ?>'>
                                        <?php echo $user['email'] ?? "<i class='bi bi-question-circle'></i>"; ?>
                                    </a> 
                                </p>
                            </div>

                            <div class='mb-4'>
                                <label class='form-label'>Card Vendor</label>
                                <select name='vendor' class='form-select'>
                                    <?php 
                                        Bank::array_to_options([
                                            "mastercard" => "Master Card",
                                            "visacard" => "Visa Card"
                                        ], $card['vendor']);
                                    ?>
                                </select>
                            </div>

                            <div class='mb-4'>
                                <label class='form-label'>Card Type</label>
                                <select name='card_type' class='form-select'>
                                    <?php 
                                        Bank::array_to_options([
                                            "debit" => "Debit Card",
                                            "credit" => "Credit Card"
                                        ], $card['card_type']);
                                    ?>
                                </select>
                            </div>

                            <div class='mb-4'>
                                <label class='form-label'>Card Number</label>
                                <input type='number' name='card_number' disabled value='<?php echo $card['card_number']; ?>' class='form-control'>
                            </div>

                            <div class='mb-4'>
                                <label class='form-label'>CVV</label>
                                <input type='number' name='cvv' value='<?php echo $card['cvv']; ?>' class='form-control' placeholder='XXX' max='999' required>
                            </div>

                            <div class='mb-4'>
                                <label class='form-label'>Expiry</label>
                                <input type='text' name='expiry' value='<?php echo $card['expiry']; ?>' class='form-control' pattern='^\d{2}\/\d{2}$' placeholder='MM/YY' required>
                            </div>

                            <hr/>

                            <div class='mb-4'>
                                <label class='form-label'>Status</label>
                                <select name='status' class='form-select'>
                                    <?php 
                                        Bank::array_to_options([
                                            "pending" => "Pending",
                                            "active" => "Activated",
                                            "inactive" => "Deactivated",
                                            "expired" => "Expired"
                                        ], $card['status']);
                                    ?>
                                </select>
                            </div>

                            <button class='btn btn-primary btn-lg w-100'>
                                Update Detail
                            </button>

                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>

</div>