<?php

$cardRoute = $managementRoute . "/cards";

$cardMenu = $managementMenu->add("card", [
    "label" => "Cards",
    "href" => Core::url( ROOT_DIR . "/{$cardRoute}" )
]);

# Focus;

Uss::route( $cardRoute . "(?:/(\d+))?", function() use($cardMenu) {

    $cardMenu->setAttr('active', true);
    $cardMenu->parentMenu->setAttr('active', true);

    require_once MANG_DIR . "/request/cards.php";
    
    Udash::view(function() {
        
        if( empty(Uss::query(3)) ) {

            require MANG_DIR . "/templates/cards.php";

        } else {

            $card = Udash::fetch_assoc( DB_TABLE_PREFIX . "_cards", Uss::query(3) );

            if( !$card ) {
                return Udash::empty_state();
            };

            $user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $card['userid'] ) ?? [];
            $href = Bank::userURL( $user['usercode'] ?? 0 );

            require MANG_DIR . "/templates/card-edit.php";

        };

    });

}, null);