<?php

$transferRoute = $financeRoute . "/transactions";

$transferMenu = $financeMenu->add('transactions', [
    "label" => "transactions",
    "href" => Core::url( ROOT_DIR . "/{$transferRoute}" )
]);

# Focus;

Uss::route( $transferRoute . "(?:/(\d+))?", function() use($transferMenu) {

    $transferMenu->setAttr('active', true);
    $transferMenu->parentMenu->setAttr('active', true);
    
    require_once FINANCE_DIR . "/request/transfer.php";

    Udash::view(function() use($transfer) {

        echo "<div class='container-fluid'>

            <h4>Transactions</h4><hr/>";

            if( empty(Uss::query(3)) ) {

                require_once __DIR__ . "/templates/transaction-list.php";

            } else {

                if( !$transfer->transfer ) {

                    return Udash::empty_state();

                } else {

                    $transfer->meta = $transfer->getTransferMeta( $transfer->transfer['tx_ref'] );
                    
                    require_once __DIR__ . "/templates/transaction-edit.php";

                }

            };

        echo "</div>";

    });

}, null);